# Astherafi Dashboard

## Overview

Astherafi is a blockchain utilities dashboard providing tools for token analysis, BSC bundled transactions, token generation, free smart contract audit, password security scoring, and staking. The application follows a full-stack architecture with a React frontend and Express backend, designed for deployment on Replit with PostgreSQL database support.

## User Preferences

Preferred communication style: Simple, everyday language.

## System Architecture

### Frontend Architecture
- **Framework**: React 18 with TypeScript
- **Routing**: Wouter (lightweight alternative to React Router)
- **State Management**: TanStack React Query for server state
- **UI Components**: shadcn/ui component library built on Radix UI primitives
- **Styling**: Tailwind CSS v4 with custom CSS variables for theming
- **Animations**: Framer Motion for UI transitions
- **Build Tool**: Vite with custom plugins for Replit integration

The frontend uses a dark theme by default with cyberpunk-inspired color variables (cyber-cyan, cyber-purple, cyber-pink). Components are organized in `client/src/components/ui/` following shadcn/ui conventions.

### Backend Architecture
- **Framework**: Express.js with TypeScript
- **Database ORM**: Drizzle ORM with PostgreSQL dialect
- **Schema Validation**: Zod with drizzle-zod integration
- **API Structure**: RESTful endpoints under `/api` prefix
- **Session Storage**: connect-pg-simple for PostgreSQL session storage

The server handles API requests and serves the static frontend in production. Development uses Vite's middleware mode for hot module replacement.

### Data Storage
- **Database**: PostgreSQL (configured via DATABASE_URL environment variable)
- **Schema Location**: `shared/schema.ts` - shared between frontend and backend
- **Migrations**: Drizzle Kit with output to `./migrations` directory
- **Current Schema**: Users table with id, username, and password fields

### Project Structure
```
├── client/           # Frontend React application
│   ├── src/
│   │   ├── components/ui/  # shadcn/ui components
│   │   ├── hooks/          # Custom React hooks
│   │   ├── lib/            # Utilities and query client
│   │   └── pages/          # Page components
├── server/           # Backend Express application
│   ├── index.ts      # Server entry point
│   ├── routes.ts     # API route definitions
│   ├── storage.ts    # Data access layer
│   └── static.ts     # Static file serving
├── shared/           # Shared code between frontend and backend
│   └── schema.ts     # Database schema definitions
└── standalone/       # Alternative cPanel deployment files
```

### Build Process
- **Development**: `npm run dev` runs the Express server with Vite middleware
- **Production Build**: `npm run build` uses esbuild for server bundling and Vite for client
- **Output**: `dist/` directory with `index.cjs` (server) and `public/` (client assets)

## External Dependencies

### Third-Party APIs
- **GoPlus Labs API**: Token security analysis at `https://api.gopluslabs.io/api/v1/token_security/` - used for analyzing EVM token contracts across multiple chains (Ethereum, BSC, Polygon, Arbitrum, Base, Avalanche, Fantom, Optimism)
- **Helius API**: Solana token metadata at `https://api.helius.xyz/v0/token-metadata` - requires HELIUS_API_KEY environment variable
- **DexScreener API**: Market data and social links at `https://api.dexscreener.com/latest/dex/tokens/`
- **Four.meme API**: Token creation on BSC at `https://four.meme/meme-api` - enables token generation with wallet authentication
- **DeepSeek API**: AI-powered token analysis at `https://api.deepseek.com` - provides sentiment, technical, and on-chain analysis scores with recommendations (requires DEEPSEEK_API_KEY)
- **NodeReal API**: BSC Block Explorer at `https://bsc-mainnet.nodereal.io/v1/` - provides address balances, token holdings, and transaction history

### Token Generator Configuration
- **Fee Wallet**: `0xa6652bd6c6ff77ebae15a14861467a5366918504` - receives platform fees
- **Deploy Cost**: 0.01 BNB
- **TokenManager2 Contract**: `0x277204675524B49D417bD0B374A1FB09465F7777` (BSC)
- **Fixed Parameters**: Total supply 1B, raised amount 24 BNB, 80% sale rate, 0.25% trading fee

### Database
- **PostgreSQL**: Required for production, connected via `DATABASE_URL` environment variable
- **Drizzle Kit**: Used for schema migrations with `npm run db:push`

### Key Runtime Dependencies
- Express.js for HTTP server
- Drizzle ORM for database operations
- TanStack React Query for frontend data fetching
- Radix UI primitives for accessible components
- Tailwind CSS for styling

### Development Tools
- Vite with React plugin
- TypeScript for type safety
- Replit-specific plugins (cartographer, dev-banner, runtime-error-modal)

### cPanel Deployment
The `standalone/` folder contains all files needed for cPanel Node.js hosting:
- `index.cjs` - Compiled server bundle
- `public/` - Frontend assets
- `package.json` - Production dependencies
- `.htaccess` - Apache/Passenger configuration
- `.env.example` - Environment variables template
- `README.txt` - Detailed deployment instructions
- `astherafi-cpanel.zip` - Ready-to-upload zip file

To prepare deployment files: `npm run build` then copy dist files to standalone/