# Astherafi Cryptocurrency Dashboard - Design Guidelines

## Design Approach

**Selected Approach:** Custom Design System inspired by modern fintech dashboards (Dune Analytics, Nansen, Debank)

**Core Principles:**
- Dark-first interface optimized for extended use
- Data density without overwhelming users
- Cyber-aesthetic with professional restraint
- Immediate tool accessibility

## Typography

**Font Stack:**
- Primary: 'Inter' (via Google Fonts CDN) - UI, data, metrics
- Monospace: 'JetBrains Mono' - addresses, hashes, code

**Type Scale:**
- Headings: text-2xl to text-4xl, font-semibold
- Body: text-sm to text-base, font-normal
- Data/metrics: text-lg to text-3xl, font-bold
- Labels: text-xs, font-medium, uppercase tracking-wide
- Monospace content: text-sm font-mono

## Layout System

**Spacing Primitives:** Use Tailwind units of 3, 4, 6, 8, 12, 16
- Component padding: p-4 to p-6
- Section spacing: gap-6 to gap-8
- Card margins: m-4
- Grid gaps: gap-4

**Sidebar Navigation:**
- Fixed left sidebar: w-64
- Logo at top (h-16 p-4)
- Navigation items with icons: p-3 rounded-lg
- Active state: subtle gradient background
- Main content area: ml-64 with p-8

## Component Library

**Navigation Sidebar:**
- Compact logo area with 'Astherafi' wordmark
- Icon + label navigation items (Heroicons via CDN)
- Tool categories: Token Analysis, Token Generator, Bundle Checker, Wallet Tools, Settings
- Bottom section: User profile + connection status indicator

**Dashboard Cards:**
- Rounded corners: rounded-xl
- Subtle borders with gradient effect
- Padding: p-6
- Shadow: shadow-lg with subtle glow effect
- Header with icon + title + action button

**Data Tables:**
- Compact row height with hover states
- Monospace for addresses/hashes
- Sortable column headers
- Inline action buttons (copy, view details)
- Pagination controls at bottom

**Chart Components:**
- Clean line charts with gradient fills
- Candlestick patterns for price data
- Network graphs for token relationships
- Use Chart.js or similar library via CDN

**Form Inputs:**
- Dark input fields: rounded-lg p-3
- Clear labels above inputs
- Validation states (error/success borders)
- Submit buttons with gradient backgrounds
- Token address inputs with ENS resolution indicators

**Action Buttons:**
- Primary: Gradient fill (cyan to blue)
- Secondary: Border with transparent background
- Sizes: px-4 py-2 (small), px-6 py-3 (medium)
- Icons alongside text where appropriate
- Disabled state: reduced opacity

**Status Indicators:**
- Connection status: green dot + "Connected to Ethereum"
- Loading states: animated spinner
- Success/error toasts: top-right notifications
- Transaction pending: progress bars

**Tool-Specific Components:**

Token Analysis:
- Search bar with autocomplete
- Token info card (price, market cap, holders)
- Holder distribution chart
- Transaction history table
- Security score badges

Token Generator:
- Multi-step form wizard
- Parameter configuration cards
- Preview section showing token details
- Deploy button with wallet connection check

Bundle Checker:
- Address input with batch upload
- Results grid showing wallet holdings
- Aggregate statistics panel
- Export data button

## Icons

Use Heroicons (outline variant) via CDN for:
- Navigation: ChartBarIcon, SparklesIcon, CubeIcon, WalletIcon, CogIcon
- Actions: ArrowPathIcon, DocumentDuplicateIcon, ArrowDownTrayIcon
- Status: CheckCircleIcon, ExclamationCircleIcon, ClockIcon

## Images

**Dashboard Background:**
- Subtle grid pattern overlay (CSS-based, not image)
- No hero image - this is a utility dashboard

**Cryptocurrency Logos:**
- Token logos displayed at 24x24px in tables/cards
- Use placeholder API like CoinGecko for dynamic token images
- Fallback to generic token icon

**Empty States:**
- Simple SVG illustrations for "No data yet" states
- Centered in content area with CTA below

## Animations

**Minimal & Purposeful:**
- Page transitions: 150ms fade
- Hover states: 100ms scale(1.02) on cards
- Loading spinners: rotate animation
- Chart data: 300ms entrance animations
- NO scroll-based animations
- NO excessive gradient shifts

## Responsive Behavior

**Desktop (default):** Full sidebar + multi-column layouts
**Tablet:** Collapsible sidebar to icons-only
**Mobile:** Hidden sidebar with hamburger menu, stacked single-column layouts

**Grid Layouts:**
- Dashboard overview: grid-cols-1 md:grid-cols-2 lg:grid-cols-3
- Tool results: grid-cols-1 lg:grid-cols-2
- Never force multi-column on mobile