const menuData = {
  'home': {
    label: 'Home',
    description: 'Welcome to Astherafi - your blockchain utilities dashboard',
    icon: '<path d="m3 9 9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline>',
    content: `
      <p style="color: var(--muted-foreground); font-size: 18px; margin-bottom: 24px;">
        Your all-in-one blockchain toolkit for token analysis, bundled transactions, and staking rewards.
      </p>
      <div class="info-grid" style="grid-template-columns: 1fr 1fr;">
        <div class="info-card" style="padding: 24px; background: linear-gradient(135deg, hsl(185, 85%, 50%, 0.1), transparent); border-color: hsl(185, 85%, 50%, 0.2);">
          <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="hsl(185, 85%, 50%)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-bottom: 12px;">
            <polygon points="13 2 3 14 12 14 11 22 21 10 12 10 13 2"></polygon>
          </svg>
          <p style="font-family: var(--font-display); font-size: 18px; font-weight: 600; margin-bottom: 8px; color: var(--foreground);">Quick Analysis</p>
          <p style="font-size: 14px; color: var(--muted-foreground);">Instantly analyze any token for security risks and contract vulnerabilities.</p>
        </div>
        <div class="info-card" style="padding: 24px; background: linear-gradient(135deg, hsl(270, 70%, 60%, 0.1), transparent); border-color: hsl(270, 70%, 60%, 0.2);">
          <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="hsl(270, 70%, 60%)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-bottom: 12px;">
            <path d="m12.83 2.18a2 2 0 0 0-1.66 0L2.6 6.08a1 1 0 0 0 0 1.83l8.58 3.91a2 2 0 0 0 1.66 0l8.58-3.9a1 1 0 0 0 0-1.83Z"></path>
            <path d="m22 17.65-9.17 4.16a2 2 0 0 1-1.66 0L2 17.65"></path>
            <path d="m22 12.65-9.17 4.16a2 2 0 0 1-1.66 0L2 12.65"></path>
          </svg>
          <p style="font-family: var(--font-display); font-size: 18px; font-weight: 600; margin-bottom: 8px; color: var(--foreground);">Bundle Transactions</p>
          <p style="font-size: 14px; color: var(--muted-foreground);">Execute multiple transactions atomically on BSC for optimal efficiency.</p>
        </div>
        <div class="info-card" style="padding: 24px; background: linear-gradient(135deg, hsl(142, 76%, 36%, 0.1), transparent); border-color: hsl(142, 76%, 36%, 0.2);">
          <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="hsl(142, 76%, 60%)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-bottom: 12px;">
            <polyline points="22 7 13.5 15.5 8.5 10.5 2 17"></polyline>
            <polyline points="16 7 22 7 22 13"></polyline>
          </svg>
          <p style="font-family: var(--font-display); font-size: 18px; font-weight: 600; margin-bottom: 8px; color: var(--foreground);">Earn Rewards</p>
          <p style="font-size: 14px; color: var(--muted-foreground);">Stake your tokens and earn passive income with competitive APY rates.</p>
        </div>
        <div class="info-card" style="padding: 24px; background: linear-gradient(135deg, hsl(30, 90%, 50%, 0.1), transparent); border-color: hsl(30, 90%, 50%, 0.2);">
          <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="hsl(30, 90%, 60%)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="margin-bottom: 12px;">
            <rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect>
            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
          </svg>
          <p style="font-family: var(--font-display); font-size: 18px; font-weight: 600; margin-bottom: 8px; color: var(--foreground);">Secure & Safe</p>
          <p style="font-size: 14px; color: var(--muted-foreground);">Check password strength and protect your wallet with industry-grade security.</p>
        </div>
      </div>
    `
  },
  'token-analyzer': {
    label: 'Token Analyzer',
    description: 'Analyze any token contract for security risks and metrics',
    icon: '<circle cx="11" cy="11" r="8"></circle><path d="m21 21-4.3-4.3"></path>',
    content: `
      <div class="input-group">
        <input type="text" class="input" placeholder="Enter token contract address (0x...)">
        <button class="btn btn-primary">Analyze</button>
      </div>
      <div class="info-grid">
        <div class="info-card">
          <p>Security Score</p>
          <p>--</p>
        </div>
        <div class="info-card">
          <p>Liquidity</p>
          <p>--</p>
        </div>
        <div class="info-card">
          <p>Holder Analysis</p>
          <p>--</p>
        </div>
      </div>
    `
  },
  'bsc-bundler': {
    label: 'BSC Bundler',
    description: 'Bundle multiple transactions on Binance Smart Chain',
    icon: '<path d="m12.83 2.18a2 2 0 0 0-1.66 0L2.6 6.08a1 1 0 0 0 0 1.83l8.58 3.91a2 2 0 0 0 1.66 0l8.58-3.9a1 1 0 0 0 0-1.83Z"></path><path d="m22 17.65-9.17 4.16a2 2 0 0 1-1.66 0L2 17.65"></path><path d="m22 12.65-9.17 4.16a2 2 0 0 1-1.66 0L2 12.65"></path>',
    content: `
      <p style="color: var(--muted-foreground); margin-bottom: 16px;">Add transactions to bundle and execute them atomically on BSC.</p>
      <div class="info-grid" style="grid-template-columns: 1fr 1fr;">
        <div class="info-card dashed">
          <div class="drop-zone">
            <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
              <path d="m12.83 2.18a2 2 0 0 0-1.66 0L2.6 6.08a1 1 0 0 0 0 1.83l8.58 3.91a2 2 0 0 0 1.66 0l8.58-3.9a1 1 0 0 0 0-1.83Z"></path>
              <path d="m22 17.65-9.17 4.16a2 2 0 0 1-1.66 0L2 17.65"></path>
              <path d="m22 12.65-9.17 4.16a2 2 0 0 1-1.66 0L2 12.65"></path>
            </svg>
            <p style="font-size: 14px; color: var(--muted-foreground);">Drop transactions here</p>
          </div>
        </div>
        <div class="info-card">
          <p style="font-weight: 500; margin-bottom: 12px;">Bundle Summary</p>
          <div class="summary-list">
            <p>Transactions: 0</p>
            <p>Estimated Gas: --</p>
            <p>Total Value: --</p>
          </div>
        </div>
      </div>
    `
  },
  'token-generator': {
    label: 'Token Generator',
    description: 'Create and deploy custom tokens in minutes',
    icon: '<circle cx="8" cy="8" r="6"></circle><path d="M18.09 10.37A6 6 0 1 1 10.34 18"></path><path d="M7 6h1v4"></path><path d="m16.71 13.88.7.71-2.82 2.82"></path>',
    content: `
      <div class="form-grid">
        <input type="text" class="input" placeholder="Token Name">
        <input type="text" class="input" placeholder="Symbol">
        <input type="text" class="input" placeholder="Total Supply">
        <input type="text" class="input" placeholder="Decimals">
      </div>
      <button class="btn btn-primary" style="width: 100%; margin-top: 16px;">Generate Token</button>
    `
  },
  'password-score': {
    label: 'Password Score',
    description: 'Check the strength of your wallet passwords',
    icon: '<rect width="18" height="11" x="3" y="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path>',
    content: `
      <input type="password" class="input" style="width: 100%;" placeholder="Enter password to check strength" id="password-input">
      <div class="info-card" style="margin-top: 16px;">
        <div style="display: flex; justify-content: space-between; margin-bottom: 8px;">
          <p style="font-size: 14px; color: var(--muted-foreground);">Strength Score</p>
          <p style="font-size: 14px; font-family: var(--font-mono);" id="score-value">--/100</p>
        </div>
        <div class="progress-bar">
          <div class="progress-fill" id="progress-fill"></div>
        </div>
      </div>
    `
  },
  'staking': {
    label: 'Staking',
    description: 'Stake tokens and earn passive rewards',
    icon: '<line x1="19" x2="5" y1="5" y2="19"></line><circle cx="6.5" cy="6.5" r="2.5"></circle><circle cx="17.5" cy="17.5" r="2.5"></circle>',
    content: `
      <div class="info-grid">
        <div class="info-card highlight" style="text-align: center;">
          <p>APY</p>
          <p style="font-size: 24px;">12.5%</p>
        </div>
        <div class="info-card" style="text-align: center;">
          <p>Your Stake</p>
          <p style="font-size: 24px;">0.00</p>
        </div>
        <div class="info-card success" style="text-align: center;">
          <p>Rewards</p>
          <p style="font-size: 24px;">0.00</p>
        </div>
      </div>
      <div class="btn-group">
        <button class="btn btn-primary">Stake</button>
        <button class="btn btn-outline">Unstake</button>
      </div>
    `
  }
};

let activeItem = 'home';

function updateContent(id) {
  const data = menuData[id];
  if (!data) return;

  activeItem = id;

  document.querySelectorAll('.nav-item').forEach(item => {
    item.classList.toggle('active', item.dataset.id === id);
  });

  document.getElementById('page-title').textContent = data.label;
  document.getElementById('page-description').textContent = data.description;
  document.getElementById('content-title').textContent = data.label;
  document.getElementById('content-icon-svg').innerHTML = data.icon;
  document.getElementById('tool-content').innerHTML = data.content;

  if (id === 'password-score') {
    setupPasswordChecker();
  }
}

function setupPasswordChecker() {
  const input = document.getElementById('password-input');
  const scoreValue = document.getElementById('score-value');
  const progressFill = document.getElementById('progress-fill');

  if (!input) return;

  input.addEventListener('input', (e) => {
    const password = e.target.value;
    let score = 0;

    if (password.length >= 8) score += 20;
    if (password.length >= 12) score += 10;
    if (password.length >= 16) score += 10;
    if (/[a-z]/.test(password)) score += 15;
    if (/[A-Z]/.test(password)) score += 15;
    if (/[0-9]/.test(password)) score += 15;
    if (/[^a-zA-Z0-9]/.test(password)) score += 15;

    score = Math.min(score, 100);
    scoreValue.textContent = `${score}/100`;
    progressFill.style.width = `${score}%`;
  });
}

document.querySelectorAll('.nav-item').forEach(item => {
  item.addEventListener('click', () => {
    updateContent(item.dataset.id);
  });
});

updateContent('home');

const toggleBtn = document.getElementById('toggle-sidebar');
const sidebar = document.querySelector('.sidebar');

if (toggleBtn && sidebar) {
  toggleBtn.addEventListener('click', () => {
    sidebar.classList.toggle('collapsed');
  });
}